package com.icetech.partner.domain.request.suzhou;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-06-05 18:07
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SuZhouWuZhongQuParamDTO implements Serializable {

    /**
     * 车场基本信息
     */
    private ParkBase parkBase;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkBase implements Serializable {

        /**
         * 三方车场code
         */
        private String parkCode;

        /**
         * 车场名称
         */
        private String parkName;

        /**
         * 登录账号
         */
        private String appKey;

        /**
         * 密码
         */
        private String password;

        /**
         * 秘钥
         */
        private String appSecret;
    }
}
