package com.icetech.partner.domain.request.suzhou;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2024-06-11 14:27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SuZhouWuZhongPayResultResponse implements Serializable {

    private Integer code;

    private String message;

    private Boolean isSuccess;

    private List<PayResult> data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class PayResult implements Serializable {
        /**
         *车牌颜色
         */
        private String codeColor;

        /**
         * 支付金额
         */
        private String payMoney;

        /**
         * 支付方式
         */
        private String payType;

        /**
         * 车牌号
         */
        private String carCode;

        /**
         * 支付时间
         */
        private String payTime;

        /**
         * 车场系统订单编号
         */
        private String parkBillId;

        /**
         * 停车场编号
         */
        private String parkCode;

        /**
         * 交易编号
         */
        private String payId;

        /**
         * 订单状态：0：未完成 1：已完成
         */
        private String orderState;
    }

}
