package com.icetech.partner.domain.request.suzhou;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 *
 * @author zhangpengzhan
 * @date 2020/11/9 10:44
 * @description: 苏州城管局 接口对接
 */
@ToString
@Getter
@Setter
public class SuZhouParkInfoRequest implements Serializable {
    /**
     * 结点	名称	必填	取值	说明
     */
    /**
     * address	停车场地址	是
     */
    private String address;
    /**
     * appointFlag	是否支持预约	是	1支持预约2不支持预约
     */
    private Integer appointFlag;
    /**
     * areaCode	省市区编号	是		按国家划分的区号-列:320506吴中区
     */
    private String areaCode;
    /**
     * enterCnt	进口数	是	整数
     */
    private Integer enterCnt;
    /**
     * exitCn	出口数	是	整数
     */
    private Integer exitCn;
    /**
     * feeDesc	收费标准描述	是
     */
    private String feeDesc;
    /**
     * feeLevel	停车场收费等级	是	1便宜2适中3偏贵
     */
    private Integer feeLevel;
    /**
     * freeNum	停车场空闲车位数量	是	小于10的整数	剩余车位数量
     */
    private Integer freeNum;
    /**
     * hearTime	心跳时间	是	yyyyMMddHHmmss	列:20191121133908
     */
    private String hearTime;
    /**
     * isCharge	是否收费	否	整数
     */
    private Integer isCharge;
    /**
     * latitude	停车场地理纬度	是	去小数点的8位	列:120594337
     */
    private String latitude;
    /**
     * longitude	停车场地理经度	是	去小数点的9位	列:31318961
     */
    private String longitude;
    /**
     * parkCode	停车场编号	是	自己的parkcode	提供静态停车场时自己提供的停车场编号
     */
    private String parkCode;
    /**
     * parkDesc	停车场描述	是
     */
    private String parkDesc;
    /**
     * parkLotNum	停车场车位数量	是	小于5位的整数	总车位数量
     */
    private Integer parkLotNum;
    /**
     * parkName	停车场名字	是
     */
    private String parkName;
    /**
     * parkType	停车场类型	是	1路内 2路外
     */
    private Integer parkType;
    /**
     * subType	停车场子类型	是	0免费1收费29 专用停车场 31  P+R停车场
     */
    private Integer subType;
    /**
     * thirdFlag	是否第三方标识	是	1是2不是	默认是1(第三方停车场自己park_code)
     */
    private String thirdFlag;
    /**
     * thirdpartyCompanies	第三方标识	是		提供静态停车场时自己提供的标识
     */
    private String thirdpartyCompanies;
    /**
     * updateTime	停车场信息修改时间	是	yyyyMMddHHmmss	列:20191121133908
     */
    private String updateTime;
}
