package com.icetech.partner.domain.request.suzhou;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 *
 * @author zhangpengzhan
 * @date 2020/11/9 10:46
 * @description: 进出场消息体
 */
@ToString
@Getter
@Setter
public class SuZhouInOutCarRequest implements Serializable {
    /**
     * parkCode	停车场编号	是		提供静态停车场时自己提供的停车场编号
     */
    private String parkCode;
    /**
     * parkName	停车场名称	是
     */
    private String parkName;
    /**
     * parkType	车场类型	是
     */
    private String parkType;
    /**
     * regionCode	省市区编号	是		按国家划分的区号-列:320506吴中区
     */
    private String regionCode;
    /**
     * inParkTrace	入场批次号	是
     */
    private String inParkTrace;
    /**
     * serialno	流水号	是
     */
    private String serialno;
    /**
     * inOperName	入场操作员名字	是
     */
    private String inOperName;

    /**
     * inOperNo	入场操作员编号	是
     */
    private String inOperNo;
    /**
     * carId	车牌号	是
     */
    private String carId;
    /**
     * carType	车辆类型	是	1-小型车2-中型车3-大型车4-其他
     */
    private String carType;
    /**
     * 结点	名称	必填	取值	说明
     *
     */
    private String carColor;

    /**
     * inGateCode	入口编号	是
     */
    private String inGateCode;
    /**
     * inTime	入场时间	是	yyyyMMddHHmmss	列:20191121133908
     */
    private String inTime;


    /**
     * inPhoto	入场图片	是
     */
    private String inPhoto;
    /**
     * inSmallPhoto	入场小图片	是
     */
    private String inSmallPhoto;
    /**
     * inConfidence	入场车牌识别度	是
     */
    private String inConfidence;
    /**
     * outBatchNo	出场批次号	是
     */
    private String outBatchNo;
    /**
     * outTime	出场时间	是	yyyyMMddHHmmss	列:20191121133908
     */
    private String outTime;
    /**
     * outGateCode	出口编号	是
     */
    private String outGateCode;
    /**
     * outPhoto	出场图片	是
     */
    private String outPhoto;
    /**
     * outSmallPhoto	出场小图片	是
     */
    private String outSmallPhoto;
    /**
     * outConfidence	出场车牌识别度	是
     */
    private String outConfidence;

    /**
     * parkTime	停车时长	是	单位分钟
     */
    private String parkTime;
    /**
     * outOperType	出场操作类型	是
     */
    private String outOperType;
    /**
     * outOperNo	出场操作员编号	是
     */
    private String outOperNo;
    /**
     * outOperName	出场操作员名字	是
     */
    private String outOperName;



    /**
     * payMoney	应收金额	是	小数点后1位	列:15.5
     */
    private String payMoney;
    /**
     * chargeMoney	实收金额	是	小数点后1位	列:8.5
     */
    private String chargeMoney;

    /**
     * payType	支付方式	是	0代表停车没有费用1现金2银行卡5公众号自助缴费8会员免费10APP缴费20市名卡21微信22支付宝
     *
     */
    private String payType;


    /**
     * thirdFlag	是否第三方标识	是	1是2不是	默认是1(第三方停车场自己park_code)
     */
    private String thirdFlag;
    /**
     * thirdpartyCompanies	第三方标识	是		提供静态停车场时自己提供的标识
     */
    private String thirdpartyCompanies;
}
