package com.icetech.partner.domain.request.shandong.weihai;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2025-04-07 16:38
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WeiHaiParkParamVo implements Serializable {

    private ParkBase parkBase;


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkBase implements Serializable {

        /**
         * 停车场编号
         */
        private String parkingCode;

        /**
         * 停车场名称
         */
        private String parkingName;

        /**
         * 平台公钥
         */
        private String platformPublicKey;

        /**
         * 用户私钥
         */
        private String userPrivateKey;

        /**
         * 接入ID
         */
        private String accessId;

        /**
         * 停车场地址
         */
        private String address;

        /**
         * 行政区划
         */
        private String regionCode;

        /**
         * 城区编号
         */
        private String areaCode;

        /**
         * 定价类型:1:政府定价;2:市场定价;3:免费
         */
        private Integer priceType;

        /**
         * 收费标准
         */
        private String feeScale;

        /**
         * 开放时间(例如:0-24小时)
         */
        private String openTime;

        /**
         * 停车位置:1路外;2路内
         */
        private Integer parkingLocate;

        /**
         * 停车场类型:1:配建停车场;2:公共停车场;3:道路停车位
         */
        private Integer parkingType;

        /**
         * 开放泊位数
         */
        private Integer openBerthNum;

        /**
         * 百度经度坐标
         */
        private String bmapX;

        /**
         * 百度纬度坐标
         */
        private String bmapY;

        /**
         * 高德经度坐标
         */
        private String gmapX;

        /**
         * 高德纬度坐标
         */
        private String gmapY;

        /**
         * 临停车位数
         */
        private Integer tempTotalNum;

        /**
         * 月租车位数
         */
        private Integer intrinsicTotalNum;

        /**
         * 访客车位数
         */
        private Integer visitorTotalNum;

        /**
         * 充电桩车位数
         */
        private Integer chargeTotalNum;

        /**
         * 上报时间
         */
        private String uploadTime;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkSendBase implements Serializable {

        /**
         * 停车场编号
         */
        private String parkingCode;

        /**
         * 停车场名称
         */
        private String parkingName;

        /**
         * 停车场地址
         */
        private String address;

        /**
         * 行政区划
         */
        private String regionCode;

        /**
         * 城区编号
         */
        private String areaCode;

        /**
         * 定价类型:1:政府定价;2:市场定价;3:免费
         */
        private Integer priceType;

        /**
         * 收费标准
         */
        private String feeScale;

        /**
         * 开放时间(例如:0-24小时)
         */
        private String openTime;

        /**
         * 停车位置:1路外;2路内
         */
        private Integer parkingLocate;

        /**
         * 停车场类型:1:配建停车场;2:公共停车场;3:道路停车位
         */
        private Integer parkingType;

        /**
         * 开放泊位数
         */
        private Integer openBerthNum;

        /**
         * 百度经度坐标
         */
        private String bmapX;

        /**
         * 百度纬度坐标
         */
        private String bmapY;

        /**
         * 高德经度坐标
         */
        private String gmapX;

        /**
         * 高德纬度坐标
         */
        private String gmapY;

        /**
         * 临停车位数
         */
        private Integer tempTotalNum;

        /**
         * 月租车位数
         */
        private Integer intrinsicTotalNum;

        /**
         * 访客车位数
         */
        private Integer visitorTotalNum;

        /**
         * 充电桩车位数
         */
        private Integer chargeTotalNum;

        /**
         * 上报时间
         */
        private String uploadTime;
    }
}
