package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/18 13:59
 * @description:异常开闸信息接口
 */
@Data
public class WarningMsgInfoRequest implements Serializable {
    /**
     *云平台停车场编码
     */
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "1495434452", position = 1)
    private String parkCode;
    /**
     * 云平台通道编号
     */
    @ApiModelProperty(value = "云平台通道编号", required = true, example = "1", position = 2)
    private String channelId;
    /**
     * 云平台订单号
     */
    @ApiModelProperty(value = "云平台订单号", required = true, example = "C21092311263110045721", position = 3)
    private String orderNum;

    /**
     *车牌号
     */
    @ApiModelProperty(value = "车牌号", required = true, example = "京A88888", position = 4)
    private String plateNum;

    /**
     *开闸时间
     */
    @ApiModelProperty(value = "开闸时间", required = true, example = "", position = 5)
    private String openTime;

    /**
     * 开闸类型 1 岗亭开闸 2 远程开闸 3遥控器开闸
     */
    @ApiModelProperty(value = "开闸类型: 1 岗亭开闸 2 远程开闸 3遥控器开闸", required = true, example = "1", position = 6)
    private Integer openType;

    /**
     * 开闸原因  1 未找到入场记录 2 缴费后未抬杆 3 非机动车放行 99 其他
     */
    @ApiModelProperty(value = "开闸原因:  1 未找到入场记录 2 缴费后未抬杆 3 非机动车放行 99 其他", required = true, example = "1", position = 7)
    private Integer openReason;


}
