package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 开关闸参数接口
 * @author zhangpengzhan
 * @date 2021/1/5 17:17
 */
@Data
public class SwitchGateInfo implements Serializable {
    /**
     * 停车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "1495434452", position = 1)
    private String parkCode;
    /**
     * 通道编码
     */
    @NotNull
    @NotBlank(message = "通道编码不能为空")
    @ApiModelProperty(value = "通道编码", required = true, example = "C10000", position = 2)
    private String channelCode;

    /**
     * 开闸类型 1 开闸 2 关闸
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "开闸类型不能为空")
    @ApiModelProperty(value = "开闸类型 1 开闸 2 关闸", required = true, example = "1", position = 3)
    private Integer switchType;

    /**
     * 车牌号
     */
    @ApiModelProperty(value = "车牌号", example = "京A88888", position = 4)
    private String plateNum;
    /**
     *订单号
     */
    @ApiModelProperty(value = "订单号", example = "D101000000", position = 5)
    private String orderNum;

    /**
     * 开闸原因备注
     */
    @ApiModelProperty(value = "开闸原因备注", example = "特殊车辆", position = 6)
    private String reason;
}
