package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/14 11:19
 * @description:月卡查询接口
 */
@Data
public class QueryMonthCardsRequest implements Serializable {
    @NotNull
    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "P100001", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "车牌号", example = "京DNF886", position = 2)
    private String plateNum;

    @ApiModelProperty(value = "手机号（查询指定月卡是需要输入手机号）", example = "13844444444", position = 3)
    private String phone;

    @ApiModelProperty(value = "分页查询页码（默认1）", example = "1", position = 4)
    private Integer pageNum;

    @ApiModelProperty(value = "分页查询单页数量（默认20 小于1000）", example = "20", position = 5)
    private Integer pageSize;
}
