package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Setter
@Getter
@ToString
public class QueryFeeRequest implements Serializable{

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号，由平台统一分配", example = "P100122", required = true, position = 1)
    private String parkCode;

    @ApiModelProperty(value = "车牌号，通道编号不传时，车牌号必传", example = "京A88888", position = 2)
    private String plateNum;

    @ApiModelProperty(value = "会员卡号", example = "123333", position = 3)
    private String cardNo;

    @ApiModelProperty(value = "订单编号，传此值可提升查询效率", example = "D111111", position = 4)
    private String orderNum;

    @ApiModelProperty(value = "通道编号（从云平台获取），车牌号不传时，通道编号必传；出口缴费时建议传此参数，否则可能会出现计费结果和出口语音播报费用不一致的问题", example = "C111111", position = 5)
    private String channelCode;

    //@ApiModelProperty(value = "抵扣明细约定", example = "", position = 6)
    private List<DeductionDetail> deductionDetails;

    @Setter
    @Getter
    @ToString
    public static class DeductionDetail implements Serializable {

        //@ApiModelProperty(value = "抵扣类型（1：权益，2：补贴，3：券，4：积分）", example = "1", position = 1)
        public int type;

        //@ApiModelProperty(value = "抵扣标识（抵扣类型为4积分时，此项为积分数，其他均为唯一标识）", example = "22", position = 2)
        public String identify;

        //@ApiModelProperty(value = "抵扣时长", example = "10", position = 3)
        public int minutes;

        //@ApiModelProperty(value = "抵扣金额（由第三方会员系统根据时长换算而来，平台不做时长转金额的处理）", example = "10.0", position = 4)
        public double amount;
    }

}
