package com.icetech.partner.domain.request.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 优惠使用查询请求
 * @author wangzhiwei
 */
@Data
public class QueryDiscountRecordRequest extends PageRequest  {
    /**
     * 车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;
    
    /**
     * 开始时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @javax.validation.constraints.NotNull(message = "开始时间不能为空")
    @ApiModelProperty(value = "当开始时间格式 yyyy-MM-dd HH:mm:ss", required = true, example = "2022-07-01 10:00:00", position = 2)
    private Date startTime;
    
    /**
     * 结束时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @javax.validation.constraints.NotNull(message = "结束时间不能为空")
    @ApiModelProperty(value = "结束时间 yyyy-MM-dd HH:mm:ss", required = true, example = "2022-07-15 10:00:00", position = 3)
    private Date endTime;
    
    /**
     * 停车记录号
     */
    @ApiModelProperty(value = "订单号", example = "2020019988778100", position = 4)
    private String orderNum;
    
    /**
     * 交易流水号
     */
    @ApiModelProperty(value = "交易流水号", example = "TR2020019988778", position = 5)
    private String tradeNo;
    @ApiModelProperty(value = "优惠券编码", example = "D2020019988778", position = 6)
    private String outDiscountNo;
}
