package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class QueryChannelCarResponse implements Serializable {

    @ApiModelProperty(value = "订单号", example = "D1495434452", position = 1)
    private String orderNum;

    @ApiModelProperty(value = "车牌号", required = true, example = "京A88888", position = 2)
    private String plateNum;

    @ApiModelProperty(value = "进场时间", example = "1657614044", position = 3)
    private Long enterTime;

    @ApiModelProperty(value = "离场识别时间，出口时必传", example = "1657614044", position = 4)
    private Long exitTime;

    @ApiModelProperty(value = "车型", example = "大众", position = 5)
    private Integer carType;

    @ApiModelProperty(value = "车辆图片URL", example = "", position = 6)
    private String imgUrl;
}
