package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Setter
@Getter
@ToString
public class QueryChannelCarRequest implements Serializable {
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "1495434452", position = 1)
    private String parkCode;
    
    @NotNull
    @NotBlank(message = "通道编码不能为空")
    @ApiModelProperty(value = "通道编码", required = true, example = "C10000", position = 2)
    private String channelCode;
}
