package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Setter
@Getter
@ToString
public class NotifyPayRequest implements Serializable {
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号，由平台统一分配", example = "P100122", required = true, position = 1)
    private String parkCode;
    
    @NotNull
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号", example = "京A88888", required = true, position = 2)
    private String plateNum;
    
    @NotNull
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "订单号", example = "D111111", required = true, position = 3)
    private String orderNum;
    
    @NotNull
    @NotBlank(message = "交易流水号不能为空")
    @ApiModelProperty(value = "交易流水号，如果是云平台交易流水号，此值从拉取费用接口获取", example = "111111", required = true, position = 4)
    private String tradeNo;
    
    /**
     * 是否本平台流水号（1 是  0否，非本平台流水号为三方用户自定义生成，且确保全局唯一性）
     */
    @ApiModelProperty(value = "是否为云平台流水号，1：是，0：否，不是云平台流水号，即第三方流水号，要确保全局唯一性", example = "1", position = 5)
    private Integer isCloudTradeNo;
    
    @NotNull
    @javax.validation.constraints.NotNull(message = "支付渠道不能为空")
    @ApiModelProperty(value = "支付渠道", example = "1", required = true, position = 6)
    private Integer payChannel;
    
    @NotNull
    @javax.validation.constraints.NotNull(message = "支付方式不能为空")
    @ApiModelProperty(value = "支付方式", example = "1", required = true, position = 7)
    private Integer payWay;

    @NotNull
    @javax.validation.constraints.NotNull(message = "需支付金额不能为空")
    @ApiModelProperty(value = "需支付金额 ，与拉取费用接口返回的needPayPrice相同", example = "10.0", required = true, position = 8)
    private Double needPayPrice;

    @javax.validation.constraints.NotNull(message = "实际支付金额不能为空")
    @ApiModelProperty(value = "实际支付金额，needPayPrice = actualPayPrice + actualDiscount", example = "10.0", required = true, position = 9)
    private Double actualPayPrice;

    @javax.validation.constraints.NotNull(message = "实际优惠金额不能为空")
    @ApiModelProperty(value = "实际优惠金额，needPayPrice = actualPayPrice + actualDiscount", example = "10.0", required = true, position = 10)
    private Double actualDiscount;
    
    /**
     * 拓展三方自有支付
     */
    @ApiModelProperty(value = "拓展三方自有支付", example = "10.0", position = 11)
    private String payTerminal;

    /**
     * 支付场景，1：场内支付（默认），2：出口支付，如果是出口缴费，云平台会放行此车辆；
     */
    @ApiModelProperty(value = "支付场景，1：场内支付（默认），2：出口支付，如果是出口缴费，云平台会放行此车辆；", example = "1", position = 12)
    private Integer payScene;

    @ApiModelProperty(value = "通道编号，出口支付时必传", example = "1", position = 13)
    private String channelId;

    @ApiModelProperty(value = "支付成功时间", example = "1680139673", position = 14)
    private Long payTime;

    /**
     * 等待出口识别结果的时间，单位毫秒。不传或为0时，表示不等待出口识别结果，
     * 只有当出口识别结果处理完成后，才能知道要开哪个口的道闸，
     * 主要用于解决ETC出口支付成功时，在同一时间，出口流程没查到ETC支付记录，导致重复支付的问题
     * 如果等待时间过后没有识别结果，那么，当下次识别时，一定会查到ETC支付记录，不会造成重复支付问题
     */
    private Boolean waitExitResult;

}
