package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/5 9:57
 */
@Data
public class MonthCardInfoRequest implements Serializable {
    /**
     * 月卡状态（1：正常，2：禁用。）
     * 注：
     * 1、月卡状态为1时：本地系统如有改车辆月卡信息，需更新该车辆月卡信息，没有改车辆月卡信息需插入一条该车辆月卡信息；
     * 2、月卡状态为2时：本地系统如有改车辆月卡信息，需删除该车辆月卡，没有改车辆月卡信息不用处理。
     */
    private int cardStatus;
    /**
     * 云平台月卡ID号，此月卡的唯一标识
     */
    private String cardId;
    /**
     * 云平台停车场编码
     */
    @NotNull
    private String parkCode;

    /**
     * 月卡产品Id
     */
    private Long productId;

    /**
     * 用户姓名/公司名称
     */
    private String cardOwner;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 月卡申办性质，详情查看数据定义部分
     1	个人
     2	公司
     */
    private int cardProperty;

    /**
     * 车牌号,可以多个。会以"/"连接。比如车牌号信息：京JS7680/京JS7681/京JS7682/京JS7683/京JS7684/京JS7685
     */
    private String plateNum;


    /**
     * 月卡开始日期，格式为yyyy-MM-dd
     * 如2017-07-01
     */
    private String startDate;

    /**
     * 月卡结束日期，格式为yyyy-MM-dd
     * 如2017-07-31
     */
    private String endDate;

    /**
     * ]开始时间，仅当月卡类型cardType取值为2时该字段有效，格式为hh:mm:ss，如08:00:00
     */
    private String startTime;

    /**
     * 结束时间，仅当月卡类型cardType取值为2时该字段有效，格式为hh:mm:ss，如20:00:00
     * 注：若结束时间小于开始时间，则代表该时间为次日时间。比如，开始时间为20:00:00，结束时间为8:00:00，则代表从当日晚上8点到次日8点有效
     */
    private String endTime;

    /**
     * 车位数量，默认为1，可支持多车位多车
     */
    private int plotCount;

    /**
     * 车位号,可以多个。会以"/"连接。车位号的多少和车位数量保持一致，比如车位信息：A001 / A002/ A003
     */
    private String plotNum;

    /**
     * 金额，单位：元
     */
    private String payMoney;

    /**
     * 办理时间（unix时间戳）
     */
    private Long operTime;

    /**
     * 月卡范围 1=全车场 2=指定区域
     */
    private int mcRange;

    /**
     * 可以多个区域编号 多个以逗号隔开 当mcRange=2使用
     */
    private  String regionCode;

    /**
     * 可以多个区域名称 多个以逗号隔开 当mcRange=2使用
     */
    private String regionName;


}
