package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 车辆信息修改接口
 * @author zhangpengzhan
 * @date 2021/1/18 14:12
 */
@Data
public class ModifyCarInfoRequest implements Serializable {
    /**
     * 云平台停车场编码
     */

    @ApiModelProperty(value = "停车场编号，由平台统一分配", example = "P100122", position = 1)
    private String parkCode;

    /**
     *云平台订单号
     */
    @NotNull
    @NotBlank(message = "云平台订单号不能为空")
    @ApiModelProperty(value = "云平台订单号", example = "D1000000", required = true, position = 2)
    private String orderNum;

    /**
     * 待修改的值
     */
    @ApiModelProperty(value = "待修改的值", example = "22222", position = 3)
    private String oldValue;

    /**
     * 修改后的值
     */
    @ApiModelProperty(value = "修改后的值", example = "44444", position = 4)
    private String newValue;

    /**
     * 操作类型 1 修改 2 删除（删除操作时只需要订单号）
     */
    @NotNull
    @javax.validation.constraints.NotNull(message = "操作类型不能为空")
    @ApiModelProperty(value = "操作类型 1 修改 2 删除（删除操作时只需要订单号）", example = "1", required = true, position = 5)
    private Integer action;

    /**
     * 修改类型 1 车牌号 2 车型 3车辆类型
     */
    @ApiModelProperty(value = "修改类型 1 车牌号 2 车型 3车辆类型", example = "1", position = 6)
    private Integer modifyType;
    
    /**
     * 修改为特殊车辆类型时的描述
     */
    @ApiModelProperty(value = "修改为特殊车辆类型时的描述", example = "1", position = 7)
    private String carDesc;
}
