package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * Description ItcPayCodeMsgRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/9/14 14:04
 */
@Data
public class ItcPayCodeMsgRequest implements Serializable {

    /**
     * 付款码
     */
    @ApiModelProperty(value = "付款码", required = true, example = "", position = 1)
    private String payCode;

    /**
     * 扫码时间，10 位时间戳
     */
    @ApiModelProperty(value = "扫码时间,10位时间戳", required = true, example = "1495434452", position = 2)
    private Long scanTime;
}
