package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description ItcHintRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/9/14 16:26
 */
@Data
public class ItcHintRequest implements Serializable {

    @NotBlank(message = "sn不能为空")
    @ApiModelProperty(value = "设备序列号\n", required = true, example = "", position = 1)
    private String sn;

    @NotNull(message = "场景不能为空")
    @ApiModelProperty(value = "场景", required = true, example = "", position = 2)
    private Integer scene;

    @ApiModelProperty(value = "车牌号", example = "", position = 3)
    private String plateNum;

    @NotNull(message = "车辆类型不能为空")
    @ApiModelProperty(value = "显示播报的车辆类型，默认为临时车；此处的类型为显示播报类型", required = true, example = "", position = 4)
    private Integer type;

    @ApiModelProperty(value = "VIP车辆类型名称", example = "", position = 5)
    private String vipTypeName;

    @ApiModelProperty(value = "月卡车的剩余天数", example = "", position = 6)
    private Integer remainDaysMc;

    @ApiModelProperty(value = "剩余车位数", example = "", position = 7)
    private Integer freeSpace;

    @ApiModelProperty(value = "停车时长，单位秒", example = "", position = 8)
    private Long parkTime;

    @ApiModelProperty(value = "停车费，单位分；出场需缴费场景下必传", example = "", position = 9)
    private Integer unpayPrice;

    @ApiModelProperty(value = "二维码URL地址", example = "", position = 9)
    private String qrCodeUrl;
}
