package com.icetech.partner.domain.request.open;

import com.icetech.cloudcenter.domain.base.Request;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wanggy
 */
@Data
public class ItcFreeSpaceRequest extends Request {

    @NotBlank(message = "sn不能为空")
    @ApiModelProperty(value = "设备序列号\n", required = true, example = "", position = 1)
    private String sn;
    
    @NotNull(message = "空车位不能为空")
    @ApiModelProperty(value = "空车位", required = true, example = "", position = 2)
    private Integer realFreeSpace;

    @NotNull(message = "总车位不能为空")
    @ApiModelProperty(value = "总车位", required = true, example = "", position = 3)
    private Integer totalSpace;
    
    @NotNull(message = "下发时间不能为空")
    @ApiModelProperty(value = "下发时间，Unix时间戳", required = true, example = "", position = 4)
    private Long time;


}

