package com.icetech.partner.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 月卡产品编辑类
 * @author zhangpengzhan
 * @date 2021/1/14 15:05
 */
@Data
public class EditMonthProductRequest implements Serializable {
    /**
     * 停车场编号
     */
    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100001", position = 1)
    private String parkCode;
    
    /**
     * 月卡产品编号(为空是则创建新的月卡产品)
     */
    @ApiModelProperty(value = "月卡产品编号(为空是则创建新的月卡产品)",  example = "111", position = 2)
    private String productId;
    
    /**
     * 月卡产品名称
     */
    @NotBlank(message = "月卡产品名称不能为空")
    @ApiModelProperty(value = "月卡产品名称", required = true, example = "月卡999", position = 3)
    private String productName;

    /**
     * 产品面额（X月）
     */
    @NotNull(message = "产品面额不能为空")
    @ApiModelProperty(value = "产品面额（X月）", required = true, example = "3", position = 4)
    private Integer duration;
    
    /**
     * 销售金额（元）
     */
    @NotBlank(message = "月销售金额不能为空")
    @ApiModelProperty(value = "销售金额（元）", required = true, example = "999", position = 5)
    private String payMoney;
    
    /**
     * 月卡产品类型（1全天2分时段）
     */
    @NotBlank(message = "月卡产品类型不能为空")
    @ApiModelProperty(value = "月卡产品类型（1全天2分时段）", required = true, example = "1", position = 6)
    private String cardType;

    /**
     * 可用开始时间2018-10-31
     */
    @NotBlank(message = "可用开始时间不能为空")
    @ApiModelProperty(value = "可用开始时间", required = true, example = "2022-07-01", position = 7)
    private String startDate;
    
    /**
     * 可用结束时间2018-10-31
     */
    @NotBlank(message = "可用开始时间不能为空")
    @ApiModelProperty(value = "可用结束时间", required = true, example = "2022-07-31", position = 8)
    private String endDate;
    
    /**
     * 开始时间点 （月卡分时段时此参数必填产品可用时间段21:00:00）
     */
    @ApiModelProperty(value = "开始时间点 （月卡分时段时此参数必填产品可用时间段21:00:00）", example = "21:00:00", position = 9)
    private String startTime;
    
    /**
     * 结束时间点（跨天开始>结束，例如09:00:00）
     */
    @ApiModelProperty(value = "结束时间点（跨天开始>结束，例如09:00:00）", example = "21:00:00", position = 9)
    private String endTime;
    
    /**
     * 购买渠道 0：仅平台可购买 1：平台和公众号均可购买 
     */
    @NotNull(message = "购买渠道不能为空")
    @ApiModelProperty(value = "购买渠道 0：仅平台可购买 1：平台和公众号均可购买", required = true, example = "1", position = 10)
    private Integer buyWay;
}
