package com.icetech.partner.domain.request.open;

import lombok.Data;

@Data
public class ETCRefundRequest {
    /**
     * 公司/集团ID
     */
    private String companyId;

    /**
     * 停车场编号，唯一
     */
    private String parkingId;

    /**
     * 渠道ID
     */
    private String channelId;

    /**
     * 退费ID
     */
    private String billId;

    /**
     * 退费请求动作ID RF+YYYYMMDDHHMMSS+6位自增序号+公司ID
     */
    private String refundRequestId;

    /**
     * 退费的通知地址
     */
    private String refundNotify;

    /**
     * 接收状态 (1、退费失败 2、退费通过)
     */
    private String refundStatus;

    /**
     * 退费关联记账日期 (涉及对账)
     */
    private String refundDate;

    /**
     * 退费的情况结果, 不超过256字符
     */
    private String refundInfo;

    /**
     * 数据签名
     */
    private String signData;
}
