package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 2.9.优惠信息通知
 */

@Setter
@Getter
@ToString
public class DiscountNotifyRequest implements Serializable {
    /**
     * 优惠券编号
     */

    @NotNull
    @NotBlank(message = "优惠编号不能为空")
    @ApiModelProperty(value = "优惠编号，必须保证在同一车场的唯一性", example = "Y100122", required = true, position = 1)
    String outDiscountNo;

    /**
     * 车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号，由平台统一分配", example = "P100122", required = true, position = 2)
    String parkCode;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "订单号", example = "111111", position = 3)
    String orderNum;

    /**
     * 车牌号
     */
    @NotNull
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号", example = "京A88888", required = true, position = 4)
    String plateNum;

    /**
     * 优惠类型，详情查看数据定义部分
     */
    @ApiModelProperty(value = "优惠类型; 1：全免,2：减免时间,3：减免金额,4：折扣", example = "1", required = true, position = 5)
    int discountType;

    /**
     * 优惠数额，详情查看数据定义部分
     */
    @NotNull
    @NotBlank(message = "优惠数额不能为空")
    @ApiModelProperty(value = "优惠数额，全免优惠时，此字段填-1；时间优惠时以分钟为单位 值为整数，金额优惠时以元为单位；折扣优惠时取值范围大于0且小于10，比如打99折时，值为9.9。", example = "30", required = true, position = 6)
    String discountNumber;

    /**
     * 发放时间（unix时间戳）
     */
    @ApiModelProperty(value = "发放时间", example = "1658816307", required = true, position = 7)
    long discountTime;
}
