package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 清除月卡信息
 * @author zhangpengzhan
 * @date 2021/1/14 11:12
 */
@Data
public class DelMonthCardRequest implements Serializable {
    @NotNull
    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "P100001", position = 1)
    private String parkCode;
    
    @NotNull
    @javax.validation.constraints.NotNull(message = "isDelAll不能为空")
    @ApiModelProperty(value = "是否清除整个车场月卡 1否 2 是", required = true, example = "1", position = 2)
    private Integer isDelAll;

    @ApiModelProperty(value = "云平台月卡ID号，此月卡的唯一标识", example = "1222", position = 1)
    private Long cardId;
}
