package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/8 18:08
 */
@Data
public class DelChargeRuleRequest implements Serializable {
    /**
     * 云平台停车场编码
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    /**
     * 规则Id
     */
    @NotNull
    @NotBlank(message = "云平台临停规则编码不能为空")
    @ApiModelProperty(value = "云平台临停规则编码", required = true, example = "11222", position = 2)
    private String ruleId;
}
