package com.icetech.partner.domain.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/1/18 15:18
 */
@Data
public class DelChannelRuleRequest implements Serializable {
    /**
     * 停车场编号
     */
    @NotNull
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    /**
     * 通道配置编号
     */
    @NotNull
    @NotBlank(message = "通道配置编号不能为空")
    @ApiModelProperty(value = "通道配置编号", required = true, example = "C100000", position = 2)
    private String channelId;
}
