package com.icetech.partner.domain.request.luogang;

import java.io.Serializable;

import lombok.Data;

@Data
public class UpdateDeviceInfoRequest implements Serializable {
    /**
     * 设备ID
     * 停车场设备ID
     * 必选: 是
     */
    protected String deviceId;
    /**
     * 设备编码
     * 必选: 是
     */
    protected String deviceNo;
    /**
     * 设备状态
     * 1:在线, 0:离线
     * 必选: 否
     */
    protected String status;
    /**
     * 是否处理
     * 1:已处理, 0:待处理
     * 必选: 否
     */
    protected String isHandler;
    /**
     * 设备异常信息
     * Json(设备警告信息/设备故障信息)
     * 必选: 否
     */
    protected String errorInfo;
    /**
     * 异常信息类型
     * 0:设备警告信息, 1: 设备故障信息
     * 必选: 否
     */
    protected String errorType;
    /**
     * 设备数据信息
     * json
     * 必选: 否
     */
    protected String devicevalue;
    /**
     * 是否属于道闸设备
     * 1:属于, 0:不属于
     * 必选: 是
     */
    protected String isBarrierGate;
    /**
     * 系统类型
     * 富士智能:1、捷顺:2、海康:3
     * 必选: 是
     */
    protected String systemType;
    /**
     * 停车场Id
     * 必选: 是
     */
    protected String parkingLotId;

}
