package com.icetech.partner.domain.request.luogang;

import java.io.Serializable;

import lombok.Data;

@Data
public class SaveDeviceInfoRequest implements Serializable {
    /**
     * 设备ID
     * 停车场系统设备Id
     * 必选: 是
     */
    protected String deviceId;
    /**
     * 设备名称
     * 必选: 是
     */
    protected String deviceName;
    /**
     * 设备编码
     * 必选: 是
     */
    protected String deviceNo;
    /**
     * 设备类型Id
     * 必选: 是
     */
    protected String typeId;
    /**
     * 设备类型名称
     * 必选: 是
     */
    protected String typeName;
    /**
     * 设备型号
     * 必选: 否
     */
    protected String model;
    /**
     * 设备规格
     * 必选: 否
     */
    protected String specifications;
    /**
     * 设备生产厂家
     * 必选: 否
     */
    protected String deviceManufacturer;
    /**
     * 生产厂家电话
     * 必选: 否
     */
    protected String manufacturePhone;
    /**
     * 设备mac
     * 必选: 否
     */
    protected String deviceMac;
    /**
     * 设备IP
     * 必选: 否
     */
    protected String deviceIP;
    /**
     * 设备序列号
     * 必选: 否
     */
    protected String deviceNumber;
    /**
     * 保养周期
     * 必选: 否
     */
    protected String serviceInterval;
    /**
     * 运维单位
     * 必选: 否
     */
    protected String maintenanceCorp;
    /**
     * 运维联系人
     * 必选: 否
     */
    protected String maintenancePerson;
    /**
     * 运维联系方式
     * 必选: 否
     */
    protected String maintenanceContact;
    /**
     * 设备唯一标识
     * 必选: 是
     */
    protected String deviceunionId;
    /**
     * 设备来源
     * 必选: 否
     */
    protected String deviceSource;
    /**
     * 安装状态
     * 必选: 否
     */
    protected String installStatus;
    /**
     * 安装时间
     * 必选: 否
     */
    protected String installTime;
    /**
     * 经度
     * 必选: 是
     */
    protected String longitude;
    /**
     * 纬度
     * 必选: 是
     */
    protected String latitude;
    /**
     * 设备位置
     * 必选: 否
     */
    protected String position;
    /**
     * 设备扩展信息
     * json
     * 必选: 否
     */
    protected String info;
    /**
     * 系统类型
     * 富士智能:1、捷顺:2、海康:3
     * 必选: 是
     */
    protected String systemType;
    /**
     * 停车场Id
     * 必选: 是
     */
    protected String parkingLotId;
}
