package com.icetech.partner.domain.request.luogang;

import java.io.Serializable;

import lombok.Data;

@Data
public class PushOrderInfoRequest implements Serializable {
    /**
     * 预约订单Id
     * 智慧运营系统停车订单Id 参考2.5获取(有预约的线下缴费存在订单ID, 无预约的线下缴费不存在订单ID)
     * 必选: 否
     */
    protected String orderId;
    /**
     * 车牌号
     * 必选: 是
     */
    protected String plateNumber;
    /**
     * 停车场ID
     * 必选: 是
     */
    protected String parkingLotId;
    /**
     * 订单金额
     * 必选: 是
     */
    protected Double orderAmount;
    /**
     * 支付时间
     * 必选: 是
     */
    protected String payTime;
    /**
     * 支付订单编号
     * 停车场系统的支付编号
     * 必选: 是
     */
    protected String payOrderNo;
    /**
     * 入场时间
     * 必选: 是
     */
    protected String inTime;
    /**
     * 出场时间
     * 必选: 是
     */
    protected String outTime;
    /**
     * 入场记录ID
     * 停车场系统的入场记录ID
     * 必选: 是
     */
    protected String inRecordId;
    /**
     * 出场记录ID
     * 停车场系统的出场记录ID
     * 必选: 否
     */
    protected String outRecordId;
}
