package com.icetech.partner.domain.request.luogang;

import java.io.Serializable;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

@Data
public class PaidNotifyRequest implements Serializable {
    public static final String PAY_STATUS_SUCCESS = "1";
    public static final String PAY_STATUS_FAILED = "2";

    /**
     * 缴费订单Id
     * 智慧运营系统停车订单Id
     * 必选: 是
     */
    @NotBlank
    protected String orderId;
    /**
     * 支付订单号
     * 必选: 是
     */
    @NotBlank
    protected String payNo;
    /**
     * 车牌号
     * 必选: 是
     */
    @NotBlank
    protected String plateNumber;
    /**
     * 停车场ID
     * 必选: 是
     */
    @NotBlank
    protected String parkingLotId;
    /**
     * 订单金额
     * 必选: 是
     */
    @NotNull
    @Min(0)
    protected Double orderAmount;
    /**
     * 支付金额
     * 必选: 是
     */
    @Min(0)
    protected Double payAmount;
    /**
     * 支付时间
     * 必选: 是
     */
    @NotBlank
    protected String payTime;
    /**
     * 支付状态
     * 1:已支付, 2:支付失败
     * 必选: 是
     */
    @NotBlank
    protected String payStatus;
}
