package com.icetech.partner.domain.request.linyi;

import lombok.Data;

import java.io.Serializable;

/**
 * 临沂-入场上报
 */
@Data
public class LinYiParkEnterRequest implements Serializable {
    /**
     * 机构号
     */
    private String instid;
    /**
     * 接入商户号
     */
    private String mchntid;
    /**
     * 停车场ID
     */
    private String psn;
    /**
     * yyyymmddhhmmss	请求时间
     */
    private String txntime;

    private String txncode;
    /**
     * 通讯流水号	yyyymmddhhmmsss+4位数(第三方车场没有则发送时自动生成)
     */
    private String seqid;
    /**
     *入场流水号	第三方车场系统的
     */
    private String inseqid;

    /**
     *入场时间	yyyymmddhhmmss
     */
    private String intime;
    /**
     *入场操作员	名称
     */
    private String inopr;
    /**
     *车牌号码
     */
    private String carno;
    /**
     *平台车场ID+第三方车场设备ID
     */
    private String deviceid;
    /**
     *设备名称
     */
    private String devicename;
    /**
     *事件类型
     * 详见数据字典
     */
    private String eventtype;


    /**
     *文件名.xxxx（图片可后续上传，停车场唯一）
     * 单个图片采用格式：日期+平台停车场ID+01（入出场类型）+第三方车场图片文件名，字段之间采用英文竖线 | 间隔。
     *
     */
    private String picurl;
    /**
     *入场类型
     */
    private String intype;
    /**
     *车场本地文件全路径，不包含IP端口
     * 例如：/down/pic/20190322/park/141445888/170053_SB.jpg
     * 平台访问需要前面加上http://xxxx:port/
     */
    private String localpicurl;
    /**
     备用字段
     */
    private String attach;
    /**
     *报文通讯mac
     */
    private String mac;
}
