package com.icetech.partner.domain.request.lanzhou;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Setter
@Getter
@ToString
public class LanZhouCommonRequest {
    /**
     * 初始版本号1.0
     */
    private String version = "1.0";
    /**
     *请求的消息类型
     */
    private String messageType = "1001";
    /**
     *业务数据按参数列表组成JSON格式字符串，然后加密成密文
     */
    private String data;
    /**
     *接入商户的商户号
     */
    private String merchantCode;
    /**
     * yyyy-MM-dd HH:mm:ss的时间字符串
     */
    private String timestamp;
    /**
     * Sha256 签名version +messageType +data +merchantCode +tiemestamp +privatekey
     */
    private String sign;
    /**
     * 车场编号
     */
    private String parkId;
}
