package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 杭州城市大脑 上传停车账单记录
 *
 * @author zhangpengzhan
 * @date 2020/8/16 10:28
 * @description:
 */
@Getter
@Setter
@ToString
public class UploadPayRecord implements Serializable {

    /**
     * 场库系统给出的账
     * 单编号
     */
    @NotNull
    private String billID;

    /**
     * 即本次车辆到达流
     * 水号（场库编号+
     * 入口编号+时间戳
     * 不可空 0100112018101
     * 2093022567
     * 16
     * （yyyyMMddHHm
     * msssss）
     */
    @NotNull
    private String uid;

    /**
     * 车牌号
     */
    @NotNull
    private String plateNo;

    /**
     * 该编号在场库系统
     * 中保证唯一
     */
    @NotNull
    private String parkingCode;

    /**
     * 计费金额（单位：
     * 分)，参见名词解
     * 释
     */
    @NotNull
    private Integer chargeFee;

    /**
     * 应收金额（单位：
     * 分)，参见名词解
     * 释
     */
    @NotNull
    private Integer shouldPay;

    /**
     * 交易金额（单位：
     * 分），参见名词解
     * 释
     */
    @NotNull
    private Integer actualPay;

    /**
     * 账单生成时间（格
     * 式：yyyy-MM-dd
     * HH:mm:ss），参
     * 见名词解释
     */
    @NotNull
    private String billTime;

    /**
     * 第三方支付渠道返
     * 回的支付成功时间
     * （格式：yyyyMM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String dealTime;

    /**
     * 现金、支付宝等，
     * 参见数据字典
     */
    @NotNull
    private Integer paidType;

    /**
     * 101-先离场后付
     * 费，参见数据字典
     */
    @NotNull
    private Integer payType;

    /**
     * 上传时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;

    /**
     * 是否通过城
     * 市大脑付费
     * 1-是0-否
     */
    @NotNull
    private Integer billWay;
}
