package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 停车记录日对账
 *
 * @author zhangpengzhan
 * @date 2020/8/18 9:36
 */
@Getter
@Setter
@ToString
public class UploadCheckRecordRequest {
    /**
     * 停车场编号
     * 该编号在场库系
     * 统中保证唯一
     */
    @NotNull
    private String parkingCode;

    /**
     *
     * 对账日期（格
     * 式：yyyy-MMdd）
     */
    @NotNull
    private String checkDate;

    /**
     * 到达记录数（根
     * 据到达时间统
     * 计）
     */
    @NotNull
    private Integer arriveNum;

    /**
     * 离开记录数（根
     * 据离开时间统
     * 计）
     */
    @NotNull
    private Integer leaveNum;

    /**
     * 到达、离开图片
     * 总记录数（根据
     * 照片时间统计）
     */
    @NotNull
    private Integer photoNum;

    /**
     *
     * 账单笔数（根据
     * 交易时间统计）
     */
    @NotNull
    private Integer payNum;

    /**
     * 对账总金额，单
     * 位（分），参见
     * 名词解释（根据
     * 交易时间统计）
     */
    @NotNull
    private Integer payTotal;

    /**
     * 上传时间（格
     * 式：yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;
}
