package com.icetech.partner.domain.request.hangzhou;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 杭州城市大脑 上传车辆离开记录
 *
 * @author zhangpengzhan
 * @date 2020/8/16 10:25
 */
@Getter
@Setter
@ToString
public class UploadCarOutData implements Serializable {

    /**
     * 即本次车辆到达流水
     * 号（场库编号+入口编
     * 号+时间戳
     * （yyyyMMddHHmmss
     * sss）
     */
    @NotNull
    private String uid;

    /**
     * 场库系统给出的车辆
     * 离开记录 id
     */
    @NotNull
    private String endID;

    /**
     * 车牌号
     */
    @NotNull
    private String plateNo;

    /**
     * 该编号在场库系统中
     * 保证唯一
     */
    @NotNull
    private String parkingCode;

    /**
     * 岗亭编号
     */
    private String gateNo;

    /**
     * 收费员编号
     */
    private String operatorCode;

    /**
     * 泊位总数
     */
    @NotNull
    private Integer totalBerthNum;

    /**
     * 开放泊位数
     */
    @NotNull
    private Integer openBerthNum;

    /**
     * 剩余开放泊位数，参
     * 见名词解释
     */
    @NotNull
    private Integer freeBerthNum;

    /**
     * 到达时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String arriveTime;

    /**
     * 停车类型，参见数据
     * 字典
     */
    @NotNull
    private Integer parkingType;

    /**
     *离开时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String endTime;

    /**
     * 入口编号
     */
    @NotNull
    private String entryNum;

    /**
     * 出口编号
     */
    @NotNull
    private String outNum;

    /**
     * 车牌颜色，参见数据
     * 字典
     */
    @NotNull
    private Integer plateColor;

    /**
     * 上传时间（格式：
     * yyyy-MM-dd
     * HH:mm:ss）
     */
    @NotNull
    private String uploadTime;

}
