package com.icetech.partner.domain.request.haida;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-05-30 10:54
 */
@Data
@AllArgsConstructor
@Builder
@NoArgsConstructor
public class HaiDaParamDTO implements Serializable {

    /**
     * 停车场编号
     */
    private String parkingCode;

    /**
     * 停车场名称
     */
    private String parkingName;

    /**
     * 停车场地址
     */
    private String address;

    /**
     * 行政区划
     */
    private String regionCode;

    /**
     * 城区编号
     */
    private String areaCode;

    /**
     * 定价类型
     */
    private Integer priceType;

    /**
     * 路内停车收费类型
     */
    private String inroadFeesType;

    /**
     * 收费标准
     */
    private String feeScale;

    /**
     * 开放时间
     */
    private String openTime;

    /**
     * 停车场模式
     */
    private Integer parkingPattern;

    /**
     * 停车位置
     */
    private Integer parkingLocate;

    /**
     * 停车场类型
     */
    private Integer parkingType;

    /**
     * 配建类型
     */
    private String attachedType;

    /**
     * 建筑类型
     */
    private Integer buildType;

    /**
     * 泊位总数
     */
    private Integer totalBerthNum;

    /**
     * 开放泊位数
     */
    private Integer openBerthNum;
    /**
     * 2000 坐标经度
     * 坐标
     */
    private String x;

    /**
     * 2000 坐标纬度
     * 坐标
     */
    private String y;

    /**
     * 百度经度坐标
     */
    private String bmapX;

    /**
     * 百度纬度坐标
     */
    private String bmapY;

    /**
     * 高德经度坐标
     */
    private String gmapX;

    /**
     * 高德纬度坐标
     */
    private String gmapY;

    /**
     * 临停车位数
     */
    private Integer tempTotalNum;

    /**
     * 月租车位数
     */
    private Integer intrinsicTotalNum;

    /**
     * 访客车位数
     */
    private Integer visitorTotalNum;

    /**
     * 充电桩车位数
     */
    private Integer chargeTotalNum;

    /**
     * 上传时间（格式：yyyy-MM-dd HH: mm: ss ）
     */
    private String uploadTime;
}
