package com.icetech.partner.domain.request.haida;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-05-29 13:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class HaiDaImageDTO implements Serializable {

    /**
     * 流水号一次车辆入场的流水号（场库编号+ 入口编号+ 时间戳（yyyy MMdd HHmmsssss ）保障唯一，不重复
     */
    private String uid;

    /**
     * 停车场编号:
     * 该编号在场库系统中保证唯一
     */
    private String parkingCode;

    /**
     * 照片编号
     */
    private String photoID;

    /**
     * 照片生成时间 格式:
     * yyyy-MM-dd HH:mm:ss
     */
    private String time;

    /**
     * 照片类型: 1:车辆入场照片; 2:车辆离场照片
     */
    private Integer type;

    /**
     * 照片名称
     */
    private String name;

    /**
     * 上传时间
     * 格式:yyyy-MM-dd HH:mm:ss
     */
    private String uploadTime;
}
