package com.icetech.partner.domain.request.dongcheng;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-02-28 14:28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BeiJingDongParkOperationRequest implements Serializable {

    /**
     * 停车场编号
     */
    public String parkSn;

    /**
     * 进入车辆数
     */
    private Integer entryPlateNum;

    /**
     * 驶离车辆数
     */
    private Integer exitPlateNum;

    /**
     * 空闲车位数
     */
    private Integer emptyBerthNum;

    /**
     * 信息服务提供商给区平台发
     * 送数据的时间（无延迟情
     * 况），即为空闲车位数变化
     * 的时间
     */
    private String sendTime;
}
