package com.icetech.partner.domain.request.dongcheng;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-02-23 10:54
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BeiJingDongChengLoginResponseVo implements Serializable {
    /**
     * 信息
     */
    private String msg;

    /**
     * 编码
     */
    private Integer code;

    /**
     * token信息
     */
    private Token data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Token implements Serializable {

        /**
         * token
         */
        private String access_token;

        /**
         * 刷新token
         */
        private String refresh_token;

        /**
         * 过期时间单位(秒)
         */
        private Integer expires_in;
    }
}
