package com.icetech.partner.domain.request.dongcheng;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-02-28 14:28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BeiJingDongChengEnterRequest implements Serializable {

    /**
     * 订单编号
     */
    public String orderSn;

    /**
     * 运营企业编号
     */
    public String manageDepartmentSn;

    /**
     * 运营企业名称
     */
    public String manageDepartmentName;

    /**
     * 停车场编号
     */
    public String parkSn;

    /**
     * 入口编号
     */
    public String entranceSn;

    /**
     * 入场记录编号
     */
    public String intoRecordSn;

    /**
     * 入场照片照片链接
     */
    public String intoPhotoUrl;

    /**
     * 车牌号
     */
    public String licencePlate;

    /**
     * 车牌颜色 蓝：0；黄：1；绿：2；黄
     * 绿：3；黑：4，白：5；其
     * 他：6
     */
    public String carColor;

    /**
     * 车型 小型车：0；中型车：1；
     * 大型车：2
     */
    public Integer carType;

    /**
     * 进场时间
     */
    public String inTime;

    /**
     * 接收时间
     */
    public String acceptTime;

    /**
     * 发送时间
     */
    public String sendTime;

    /**
     * 信息系统服
     * 务商编号
     */
    public String infoServiceSn;

    /**
     * 信息系统服
     * 务商名称
     */
    public String infoServiceName;

    /**
     * 停车场名称
     */
    public String parkName;

}
