package com.icetech.partner.domain.request.danyang;

import lombok.Data;

/**
 * 获取停车费二维码
 *
 * @author FGD
 */
@Data
public class GetPayQRCodeRequest {
    /**
     * 停车场编号
     */
    protected String parkCode;
    /**
     * 车场订单号
     */
    protected String orderNo;
    /**
     * 设备编码
     */
    protected String deviceCode;
    /**
     * 车牌号(含中文，URL编码)
     */
    protected String plateNum;
    /**
     * 小票号(取卡取票)
     */
    protected String cardNo;
    /**
     * 入场时间（yyyy-MM-dd HH:mm:ss）
     */
    protected String inTime;
    /**
     * 停车时长（单位：分钟）
     */
    protected Integer elapsedTime;
    /**
     * 订单金额（分）
     */
    protected Integer amount;
    /**
     * 出场时间（yyyy-MM-dd HH:mm:ss） 场内支付取当前时间
     */
    protected String outTime;
}
