package com.icetech.partner.domain.request.danyang;

import lombok.Data;

/**
 * 出场数据提交
 *
 * @author FGD
 */
@Data
public class ExitRequest {
    /**
     * 停车场编号
     */
    protected String parkCode;
    /**
     * 车牌号，不允许为空
     */
    protected String plateNo;
    /**
     * 入场取票号/无牌车入场的卡号
     */
    protected String cardNo;
    /**
     * 入场时间，不允许为空
     */
    protected String entryTime;
    /**
     * 出场时间，不允许为空
     */
    protected String leaveTime;
    /**
     * 提前缴费金额（分）
     */
    protected Integer preMoney;
    /**
     * 岗亭或出口缴费机 收费金额（分）
     */
    protected Integer payMoney;
    /**
     * 出口支付方式  详见附录1.2
     */
    protected Integer payType;
    /**
     * 抵扣金额 单位：分
     */
    protected Integer ticketMoney;
    /**
     * 抵扣时间 单位：秒
     */
    protected Integer ticketTime;
    /**
     * 免费金额 单位：分
     */
    protected Integer freeMoney;
    /**
     * 车辆类型 详见附录1.1
     */
    protected Integer carType;
    /**
     * 出口名称/出口ip/设备编码 三选一
     */
    protected String leavePlace;
    /**
     * 出口抓拍图片方式：Base64 / Url 二选一 可配置是否上传
     */
    protected String imgName;

}
