package com.icetech.partner.domain.request.danyang;

import lombok.Data;

/**
 * 免密支付数据提交
 *
 * @author FGD
 */
@Data
public class AutoPayRequest {
    /**
     * 停车场编号
     */
    protected String parkCode;
    /**
     * 车牌号，不允许为空
     */
    protected String plateNo;
    /**
     * 入场取票号/无牌车入场的卡号
     */
    protected String cardNo;
    /**
     * 入场时间，不允许为空
     */
    protected String entryTime;
    /**
     * 出场时间，不允许为空
     */
    protected String leaveTime;
    /**
     * 应收金额（分）
     */
    protected Integer totalMoney;
    /**
     * 出口名称/出口ip/出口设备编码 三选一
     */
    protected String leavePlace;
    /**
     * 出口抓拍图片方式：Base64 / Url 二选一 可配置是否上传
     */
    protected String imgName;
}
