package com.icetech.partner.domain.request.bst;

import com.icetech.partner.domain.request.bst.AdSpaceResultsVo;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2023-06-14 10:01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BstParkInitResultVo implements Serializable {

    /**
     * 车场名称
     */
    private String name;

    /**
     * 	停车场编号（内部ID）
     */
    private String parkNumber;

    /**
     * 配的车场账户Id
     */
    private String accountId;

    /**
     *分配的车场账户秘钥
     */
    private String secret;

    /**
     * 分是否初始化成功。true为成功，false 为失败
     */
    private Boolean isSuccess;

    /**
     * 提示消息
     */
    private String message;

    /**
     * 广告位信息集合
     */
    private List<AdSpaceResultsVo> adSpaceResults;
}
