package com.icetech.partner.domain.request.bst;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-06-14 9:58
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AdSpaceResultsVo implements Serializable {

    /**
     * 停车场编号
     */
    private String parkNumber;

    /**
     * 广告位编号
     */
    private String spaceNumber;

    /**
     * 广告位名称
     */
    private String name;

    /**
     * 设备类型 0：公众号；1：小程序； 2：APP；3：缴费机 4：补交机 ；5;电视机；6：支付宝；9;通用设备
     */
    private Integer deviceType;

    /**
     * 触发事件。 0:车牌查询页（输入车牌页面）；1:支付完成页（支付完毕）；2:入场消息推送也；3:出场消息推送页；4:优惠活动广告页； 5:首页广告；6:支付确认（付款前）;7：启动页；9;弹出式广告页面;10:口令广告15：一般页面广告;16:公众号菜单栏;17:线下二维码;32:其他页
     */
    private Integer triggerEvent;

    /**
     * 分配的广告位账户Id。通过该账号可以编程来获取可播放的广告,即访问api/ad/bid接口
     */
    private String accountId;

    /**
     * 分配的广告位秘钥
     */
    private String secret;

    /**
     * 是否初始化成功。true为成功，false 为失败
     */
    private Boolean isSuccess;

    /**
     * 消息。isSuccess=true时通常为空，isSuccess=false 提示失败的原因
     */
    private String message;
}
