package com.icetech.partner.domain.piaotong;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class QueryInvoiceFullResponse extends QueryInvoiceResponse {
//    securityCode
//    vatPlatformInvPreviewUrl
//    extensionNum
//    diskNo
    /**
     * 发票种类代码
     * String(2)
     * 是
     * 发票种类代码。81：电子发票（增值税专用发票）82：电子发票（普通发票）10：增值税电子普通发票08：增值税电子专用发票04：增值税普通发票01：增值税专用发票
     */
    protected String invoiceKind;
    /**
     * 开票人税局账号
     * String(50)
     * 否
     * 电子税局登录账号（手机号或身份证号）
     */
    protected String account;
    /**
     * 实名认证二维码图片
     * String（不定长)
     * 否
     * 实名认证二维码图片，base64字符串。code为3999时返回
     */
    protected String authenticationQrcode;
    /**
     * 实名认证二维码认证id
     * String（32-50)
     * 否
     * 实名认证二维码认证id，code为3999时返回
     */
    protected String authId;
    /**
     * 自定义数据
     * String(0-200)
     * 否
     * 自定义数据
     */
    protected String definedData;
    /**
     * 全电发票号码
     * String(20)
     * 否
     * 全电发票号码=发票代码+发票号码
     */
    protected String electronicInvoiceNo;
    /**
     * 发票xml文件
     * String（不定长）
     * 否
     * 非必传，若开票成功没传，需要调用获取2.20接口获取，不定长，Base64字符串
     */
    protected String invoiceXml;
}
