package com.icetech.partner.domain.piaotong;

import lombok.Data;

@Data
public  class PushInvoiceRequest {
    /**
     * 纳税人识别号
     * String（15-20）
     * 是
     * 开票方纳税人识别号
     */
    protected String taxpayerNum;
    /**
     * 发票请求流水号
     * String（20）
     * 是
     * 发票请求流水号
     */
    protected String invoiceReqSerialNo;
    /**
     * 开票类型
     * String(1)
     * 是
     * 开票类型
     * 1：蓝票；2：红票；3：蓝废；4：红废。
     * 注：电子发票会出现验签失败自动作废
     */
    protected String invoiceType;
    /**
     * 发票状态码
     * String（4）
     * 是
     * 发票状态码。
     * 0000：开票成功；6666：未开票（撤回开票中发票）；9999：开票失败。
     */
    protected String code;
    /**
     * 发票状态描述
     * String（100）
     * 否
     * 发票状态描述（成功/失败原因）
     */
    protected String msg;
    /**
     * 订单号
     * String（20）
     * 否
     * 开票成功时，必传，失败时，不传
     */
    protected String tradeNo;
    /**
     * 防伪码
     * String（100）
     * 否
     * 开票成功时，必传，普通发票使用，增值税发票返回为空
     */
    protected String securityCode;
    /**
     * 二维码
     * String（1000）
     * 否
     * 开票成功时，必传，失败时，不传
     */
    protected String qrCode;
    /**
     * 发票代码
     * String（12）
     * 否
     * 开票成功时，必传，失败时，不传
     */
    protected String invoiceCode;
    /**
     * 发票号码
     * String（8）
     * 否
     * 开票成功时，必传，失败时，不传
     */
    protected String invoiceNo;
    /**
     * 开票日期
     * String(19)
     * 否
     * 开票成功时，必传yyyy-MM-dd HH:mm:ss，失败时，不传
     */
    protected String invoiceDate;
    /**
     * 不含税金额
     * String（16）
     * 否
     * 开票成功时，必传，保留小数点后2位，以元为单位精确到分，失败时，不传
     */
    protected String noTaxAmount;
    /**
     * 税额
     * String（16）
     * 否
     * 开票成功时，必传，保留小数点后2位，以元为单位精确到分，失败时，不传
     */
    protected String taxAmount;
    /**
     * 版式文件类型
     * String(3)
     * 否
     * 版式文件类型。
     * pdf：pdf文件格式；ofd：ofd文件格式。
     */
    protected String invoiceLayoutFileType;
    /**
     * 发票pdf文件
     * String(不定长)
     * 否
     * 电子发票开票成功时，即发票种类代码为10或08时，必传，失败时，不传
     * 不定长，Base64字符串，通过票通提供的SDK进行解码，其他发票种类不传
     */
    protected String invoicePdf;
    /**
     * 发票下载Url
     * String(不定长)
     * 否
     * 电子发票开票成功时，即发票种类代码为10或08时，必传，失败时，不传
     * 不定长，Base64字符串，通过票通提供的SDK进行解码，其他发票种类不传票通电子普票开票接口文档
     */
    protected String downloadUrl;
    /**
     * 自定义数据
     * String(0-200)
     * 否
     * 自定义数据，在开票接口中使用，会按照定义返回
     */
    protected String definedData;
    /**
     * 二维码编号
     * String（10-20）
     * 否
     * 二维码编号，二维码唯一标识，扫码开票的发票才有该值
     */
    protected String invoiceQrcodeNo;
    /**
     * 公共服务平台发票预览Url
     * String(不定长)
     * 否
     * 公共服务平台发票预览Url，Base64字符串，使用公共服务平台生成版式文件时必填
     */
    protected String vatPlatformInvPreviewUrl;
    /**
     * 分机号
     * String(1-10)
     * 是
     * 开票所用税盘分机号
     */
    protected String extensionNum;
    /**
     * 机器编号
     * String(12)
     * 否
     * 开票所用税盘机器编号
     */
    protected String diskNo;
    /**
     * 电子发票预览二维码url
     * String
     * 否
     * 不定长，Base64字符串。
     * 同2.3开具电子蓝票接口返回的qrCodePath
     */
    protected String invPreviewQrcodePath;
    /**
     * 电子发票预览二维码图片
     * String
     * 否
     * 不定长，Base64字符串，扫码查看发票开票状态。
     * 同2.3开具电子蓝票接口返回的qrCode
     */
    protected String invPreviewQrcode;
}
