package com.icetech.partner.domain.nuonuo;

import lombok.Data;

@Data
public class NuoInvoiceResultResponse {

    /**
     * 发票请求流水号
     */
    private String serialNo;

    /**
     * 返回码
     */
    private String code;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 发票状态
     */
    private String status;

    /**
     * 发票状态描述
     */
    private String statusMsg;

    /**
     * 失败原因
     */
    private String failCause;

    /**
     * 发票pdf地址
     */
    private String pdfUrl;

    /**
     * 发票图片地址
     */
    private String pictureUrl;

    /**
     * 开票时间
     */
    private long invoiceTime;

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票号码
     */
    private String invoiceNo;

    /**
     * 全电发票号码
     */
    private String allElectronicInvoiceNumber;

    /**
     * 不含税金额
     */
    private String exTaxAmount;

    /**
     * 合计税额
     */
    private String taxAmount;

    /**
     * 价税合计
     */
    private String orderAmount;

    /**
     * 购方名称（付款方名称）
     */
    private String payerName;

    /**
     * 购方税号（付款方税号）
     */
    private String payerTaxNo;

    /**
     * 购方地址
     */
    private String address;

    /**
     * 购方电话
     */
    private String telephone;

    /**
     * 购方开户行及账号
     */
    private String bankAccount;

    /**
     * 发票种类
     */
    private String invoiceKind;

    /**
     * 校验码
     */
    private String checkCode;

    /**
     * 二维码
     */
    private String qrCode;

    /**
     * 税控设备号
     */
    private String machineCode;

    /**
     * 发票密文
     */
    private String cipherText;

    /**
     * 含底图纸票pdf地址
     */
    private String paperPdfUrl;

    /**
     * 发票ofd地址
     */
    private String ofdUrl;

    /**
     * 开票员
     */
    private String clerk;

    /**
     * 收款人
     */
    private String payee;

    /**
     * 复核人
     */
    private String checker;

    /**
     * 销方银行账号
     */
    private String salerAccount;

    /**
     * 销方电话
     */
    private String salerTel;

    /**
     * 销方地址
     */
    private String salerAddress;

    /**
     * 销方税号
     */
    private String salerTaxNum;

    /**
     * 销方名称
     */
    private String saleName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 成品油标志
     */
    private String productOilFlag;

    /**
     * 图片地址
     */
    private String imgUrls;

    /**
     * 分机号
     */
    private String extensionNumber;

    /**
     * 终端号
     */
    private String terminalNumber;

    /**
     * 部门门店id
     */
    private String deptId;

    /**
     * 开票员id
     */
    private String clerkId;

    /**
     * 对应蓝票发票代码
     */
    private String oldInvoiceCode;

    /**
     * 对应蓝票发票号码
     */
    private String oldInvoiceNo;

    /**
     * 对应蓝票全电发票号码
     */
    private String oldEleInvoiceNumber;

    /**
     * 清单标志
     */
    private String listFlag;

    /**
     * 清单项目名称
     */
    private String listName;

    /**
     * 购方手机
     */
    private String phone;

    /**
     * 购方邮箱推送邮箱
     */
    private String notifyEmail;

    /**
     * 是否机动车类专票
     */
    private String vehicleFlag;

    /**
     * 数据创建时间
     */
    private String createTime;

    /**
     * 数据更新时间
     */
    private String updateTime;

    /**
     * 代开标志
     */
    private String proxyInvoiceFlag;

    /**
     * 用于开票的订单的时间
     */
    private String invoiceDate;

    /**
     * 开票类型
     */
    private String invoiceType;

    /**
     * 冲红原因
     */
    private String redReason;

    /**
     * 作废时间
     */
    private String invalidTime;

    /**
     * 作废来源
     */
    private String invalidSource;

    /**
     * 全电纸票作废原因
     */
    private String invalidReason;

    /**
     * 其他作废原因详情
     */
    private String specificReason;

    /**
     * 发票特定要素
     */
    private String specificFactor;

    /**
     * 购买方经办人姓名
     */
    private String buyerManagerName;

    /**
     * 经办人证件类型
     */
    private String managerCardType;

    /**
     * 经办人证件号码
     */
    private String managerCardNo;

    /**
     * 业务方自定义字段1
     */
    private String bField1;

    /**
     * 业务方自定义字段2
     */
    private String bField2;

    /**
     * 业务方自定义字段3
     */
    private String bField3;

}
