package com.icetech.partner.domain.model.kuangu;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
public class GetInvoiceFileRequest {
    /**
     * 销方纳税人识别号 是
     */
    protected String taxcode;
    /**
     * 销方托管税控设备编号 是
     */
    protected String taxDeceiveSN;
    /**
     * 发票代码 是
     * 2.1增值税电子普通发票申请提交接口中使用的 seqNumber
     */
    protected String invoiceCode;
    /**
     * 发票号码 是
     */
    protected String invoiceNum;
    /**
     * 文件类型 否
     * 12：公共服务平台OFD（默认）13：公共服务平台PDF23：第三方签章PDF
     */
    protected Integer fileType;
    /**
     * 是否获取图片 否
     * 0：不获取图片1：获取版式文件转换的图片（仅限OFD）
     */
    protected Integer getImage;

    public static final int FILE_TYPE_OFD = 12;
    public static final int FILE_TYPE_PDF = 13;
    public static final int FILE_TYPE_PDF_SIGN = 23;

    public static final int GET_IMAGE_TRUE = 1;
    public static final int GET_IMAGE_FALSE = 0;
}
