package com.icetech.partner.domain.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * Description TwentyFourHourChargeRule
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/24 6:57 下午
 */
@Data
public class TwentyFourHourChargeRule implements Serializable {

    @NotNull(message = "免费时长不能为空")
    @ApiModelProperty(value = "免费时长（分钟）", required = true, example = "1", position = 1)
    private Integer freetime;

    @NotNull(message = "累计24小时免费时长是否使用多次不能为空")
    @ApiModelProperty(value = "累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2）", required = true, example = "1", position = 2)
    private Integer isFreetimeOnce;

    @NotNull(message = "是否使用一天最大收费限额不能为空")
    @ApiModelProperty(value = "是否使用一天最大收费限额(一天) 0：禁用 1：启用 默认为0", required = true, example = "1", position = 3)
    private Integer daynightmaxfeeusing;

    @NotNull(message = "最大收费限额类型不能为空")
    @ApiModelProperty(value = "最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费", required = true, example = "1", position = 4)
    private Integer daynightmaxfeetype;

    @NotNull(message = "24小时统计方式不能为空")
    @ApiModelProperty(value = "24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断", required = true, example = "1", position = 5)
    private Integer daynightmaxfeecounttype;

    @ApiModelProperty(value = "小型车单天最高收费金额，单位元", example = "1.00", position = 6)
    private String daynightmaxfee;

    @ApiModelProperty(value = "大型车单天最高收费金额，单位元", example = "1.00", position = 7)
    private String daynightmaxfeeBig;

    @NotNull(message = "时间分割分钟数不能为空")
    @ApiModelProperty(value = "时间分割分钟数，（只能是30或60）单位分钟，会将一天24小时按分割分钟数等额平均分开来设置计费", required = true, example = "30", position = 8)
    private Integer divisionTime;

    @NotNull(message = "是否启用跨天后收费不能为空")
    @ApiModelProperty(value = "是否启用跨天后收费， 1：是， 2：否， 默认为2", example = "1", required = true, position = 9)
    private Integer isOverTimeSet;

    @ApiModelProperty(value = "跨天后每间隔多长时间，单位分钟", example = "100", position = 10)
    private Integer feespantimestep;

    @ApiModelProperty(value = "小型车跨天后单位费用，单位元", example = "1.00", position = 11)
    private String feespanratestep;

    @ApiModelProperty(value = "大型车跨天后单位费用，单位元", example = "30.00", position = 12)
    private String feespanratestepBig;

    @NotNull(message = "是否区分大小型车计费不能为空")
    @ApiModelProperty(value = "是否区分大小型车计费（0：否，1：是）", required = true, example = "1", position = 13)
    private Integer isSmallbigcarSet;

    @NotNull(message = "24小时计费详情不能为空")
    @ApiModelProperty(value = "24小时计费详情", example = "", required = true, position = 14)
    private List<TwentyFourHourChargeRuleDetails> details;

    @Data
    public static class TwentyFourHourChargeRuleDetails implements Serializable {

        @ApiModelProperty(value = "大型车单位费用，单位元", example = "90", position = 1)
        private String feespanrateBig;

        @ApiModelProperty(value = "小型车单位费用，单位元；", example = "90", position = 2)
        private String feespanrate;

        @ApiModelProperty(value = "计费时间点，单位分钟；如1.5小时，此值为90；", example = "90", position = 3)
        private Integer feespantime;
    }
}
