package com.icetech.partner.domain.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description CurrencyChargeRule
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/24 6:36 下午
 */
@Data
public class CurrencyChargeRule implements Serializable {

    @NotNull(message = "免费时长不能为空")
    @ApiModelProperty(value = "免费时长（分钟）", required = true, example = "1", position = 1)
    private Integer freetime;

    @NotNull(message = "累计24小时免费时长是否使用多次不能为空")
    @ApiModelProperty(value = "累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2）", required = true, example = "1", position = 2)
    private Integer isFreetimeOnce;

    @NotNull(message = "是否使用一天最大收费限额(一天)不能为空")
    @ApiModelProperty(value = "是否使用一天最大收费限额(一天) 0：禁用 1：启用 默认为0", required = true, example = "1", position = 3)
    private Integer daynightmaxfeeusing;

    @NotNull(message = "最大收费限额类型不能为空")
    @ApiModelProperty(value = "最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费", required = true, example = "1", position = 4)
    private Integer daynightmaxfeetype;

    @NotNull(message = "24小时统计方式不能为空")
    @ApiModelProperty(value = "24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断", required = true, example = "1", position = 5)
    private Integer daynightmaxfeecounttype;

    @ApiModelProperty(value = "小型车单天最高收费金额，单位元", example = "1.00", position = 6)
    private String daynightmaxfee;

    @ApiModelProperty(value = "大型车单天最高收费金额，单位元", example = "1.00", position = 7)
    private String daynightmaxfeeBig;

    @NotNull(message = "是否区分工作日非工作日计费不能为空")
    @ApiModelProperty(value = "是否区分工作日非工作日计费， 1：是 2：否，默认为2", required = true, example = "1", position = 8)
    private Integer isspecialdaycharge;

    @NotNull(message = "通用计费方式或工作日计费方式不能为空")
    @ApiModelProperty(value = "通用计费方式或工作日计费方式，1：按次计费 2：按停车时长计费，不区分时工作日非工作日时，此为通用计费配置，区分时，此为工作日计费方式；", required = true, example = "1", position = 9)
    private Integer oneBillmethod;

    @ApiModelProperty(value = "非工作日计费方式，1：按次计费 2：按停车时长计费", example = "1", position = 10)
    private Integer twoBillmethod;

    @NotNull(message = "是否区分大小型车计费不能为空")
    @ApiModelProperty(value = "是否区分大小型车计费（0：否，1：是）", required = true, example = "1", position = 11)
    private Integer isSmallbigcarSet;

    @NotNull(message = "fistConfig不能为空")
    @ApiModelProperty(value = "不区分时，此为通用计费配置，区分时，此为工作日计费配置，请根据计费方式，查看具体的参数说明;", required = true, example = "", position = 12)
    private ChargeMethodConfig firstConfig;

    @ApiModelProperty(value = "非工作日计费配置，不区分工作日非工作日时，该参数不传；请根据计费方式，查看具体的参数说明;", example = "", position = 13)
    private ChargeMethodConfig twoConfig;
}
