package com.icetech.partner.domain.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * Description 收费方式配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/22 17:54
 */
@Data
public class ChargeMethodConfig implements Serializable {

    /**
     * 是否开启每次收费开关 1是 2否  默认是1
     */
    @NotNull
    @ApiModelProperty(value = "是否开启“每次收费”开关，1：是，2：否 ， 默认为1(按次计费配置)", required = true, example = "1", position = 1)
    private Integer isopenoncecharge;

    /**
     * 每次收费金额 元
     */
    @ApiModelProperty(value = "小型车每次收费金额，单位元(按次计费配置)", example = "8.8", position = 2)
    private String oncechargefee;

    /**
     * 大型车每次收费金额 元
     */
    @ApiModelProperty(value = "大型车每次收费金额，单位元(按次计费配置)", example = "8.8", position = 3)
    private String oncechargefeeBig;

    /**
     * 是否开启按分钟收费开关 1是 2否 默认否
     */
    @NotNull
    @ApiModelProperty(value = "是否开启“按分钟收费”开关， 1：是， 2：否， 默认2(按次计费配置)", required = true, example = "2", position = 4)
    private Integer isopenother2;

    /**
     * 多少分钟范围   分钟
     */
    @ApiModelProperty(value = "多少分钟范围，单位分钟(按次计费配置)", example = "20", position = 5)
    private Integer timeFrame;

    /**
     * 多少分钟范围计费多少钱 元
     */
    @ApiModelProperty(value = "小型车多少分钟范围计费多少钱，单位元(按次计费配置)", example = "10", position = 6)
    private String timeFrameOncefee;

    /**
     * 大型车多少分钟范围计费多少钱 元
     */
    @ApiModelProperty(value = "大型车多少分钟范围计费多少钱，单位元(按次计费配置)", example = "20", position = 7)
    private String timeFrameOncefeeBig;

    /**
     * 超时多少分钟范围每次收费多少钱 元
     */
    @ApiModelProperty(value = "小型车超时多少分钟范围每次收费多少钱，单位元(按次计费配置)", example = "10", position = 8)
    private String otherTimeframeOncefee;

    /**
     * 大型车超时多少分钟范围每次收费多少钱 元
     */
    @ApiModelProperty(value = "大型车超时多少分钟范围每次收费多少钱，单位元(按次计费配置)", example = "20", position = 9)
    private String otherTimeframeOncefeeBig;

    /**
     * 是否有附加选择项 1是 2否 默认为2
     */
    @NotNull
    @ApiModelProperty(value = "是否有附加选择项，1：是，2：否，默认为2(按次计费配置)", required = true, example = "1", position = 10)
    private Integer isattachoption;

    /**
     * 附加选择超过分钟数  分钟
     */
    @ApiModelProperty(value = "附加选择超过分钟数(按次计费配置+按时长计费配置)", example = "10", position = 10)
    private Integer overTime;

    /**
     * 加收过夜费 元
     */
    @ApiModelProperty(value = "小型车加收过夜费，单位元(按次计费配置)", example = "10", position = 11)
    private String addOvernightFee;

    /**
     * 大型车加收过夜费 元
     */
    @ApiModelProperty(value = "大型车加收过夜费，单位元(按次计费配置)", example = "10", position = 12)
    private String addOvernightFeeBig;

    /**
     * 超出多少分钟配置是否起作用 1：是 2否 默认为2
     */
    @NotNull
    @ApiModelProperty(value = "超出多少分钟配置是否起作用 1：是 2否(按时长计费配置)", required = true, example = "1", position = 13)
    private Integer isOverTimeSet;

    /**
     * 单位时间  分钟
     */
    @ApiModelProperty(value = "单位时长，单位分钟(按时长计费配置)", example = "10", position = 14)
    private Integer feespantime;

    /**
     * 小型车单位金额，单位元
     */
    @ApiModelProperty(value = "小型车单位金额，单位元(按时长计费配置)", example = "10", position = 15)
    private String feespanrate;

    /**
     * 大型车单位金额 元
     */
    @ApiModelProperty(value = "大型车单位金额，单位元(按时长计费配置)", example = "10", position = 16)
    private String feespanrateBig;

    /**
     * 阶梯计费详情
     */
    @NotNull
    @ApiModelProperty(value = "阶梯计费详情(按时长计费配置)", example = "", position = 17)
    private List<StepChargeDetails> stepChargeDetails;


    @Data
    public static class StepChargeDetails implements Serializable {

        /**
         * 计时开始时间 分钟
         */
        @NotNull
        @ApiModelProperty(value = "计时开始时间，单位分钟", required = true, example = "5", position = 1)
        private Integer startTimeModule;

        /**
         * 计时结束时间 分钟
         */
        @NotNull
        @ApiModelProperty(value = "计时结束时间，单位分钟", required = true, example = "10", position = 2)
        private Integer endTimeModule;

        /**
         * 单位时间  分钟
         */
        @ApiModelProperty(value = "单位时长，单位分钟", example = "10", position = 3)
        private Integer feespantime;

        /**
         * 小型车单位金额，单位元
         */
        @ApiModelProperty(value = "小型车单位金额，单位元", example = "10", position = 4)
        private String feespanrate;

        /**
         * 大型车单位金额 元
         */
        @ApiModelProperty(value = "大型车单位金额，单位元", example = "10", position = 5)
        private String feespanrateBig;
    }

}
